# 타이밍
자신의 방법을 정말로 최적화하고 싶다면 이 게임에서 시간이 어떻게 측정되는지 이해해야 해요. 이 해금은 바로 그것에 관한 것이에요.

## 새로운 함수
어떤 일이 얼마나 오래 걸리는지 측정하는 데 유용한 두 가지 함수가 있어요:

`get_time()`은 게임 시작 후 경과 시간을 초 단위로 반환해요.

`get_tick_count()`는 실행 시작 후 수행된 틱 수를 반환해요.

이 두 함수와 `quick_print()`는 완전히 무료예요. 심지어 호출 연산도 무료예요.

## 런타임 상세 정보

### 미리 알아두기
이것은 실제 세계에서 성능이 작동하는 방식이 아니에요. 이것들은 일관되고 이해하기 쉬운 타이밍 모델을 갖기 위해 이 게임을 위해 만들어진 규칙일 뿐이에요.
코드를 극도로 최적화하고 싶을 때만 신경 쓰게 될 거예요.


코드 실행의 기본 시간 단위는 "tick"이라고 불려요. 속도 업그레이드와 파워가 없으면, 실행은 초당 `400` ticks의 속도로 진행돼요.

일반적으로 `+, -, *, /, //, %, and, or, ...`와 같이 두 값을 결합하는 연산은 실행하는 데 1 tick이 걸려요.
단일 값 `-`와 `not`은 무료예요.
`if` 분기도 실행하는 데 1 tick이 걸려요 (조건 표현식을 평가하는 데 걸리는 시간 외에).
함수 호출과 변수 읽기 및 쓰기는 무료이지만, 함수 정의는 1 tick이 걸려요.
`import` 문은 무료예요.
`.` 연산자로 import된 모듈에 접근하는 것은 무료예요.
함수나 모듈이 인수나 변수 할당을 통해 전달된 경우, 이를 사용하면 0 대신 1 tick이 비용으로 들어요.
`for`와 `while` 루프는 시작하는 데 1 tick이 걸리지만, 반복 자체는 무료예요 (조건/시퀀스 표현식을 평가하는 시간은 제외).
`return`, `break`, `continue`는 모두 무료예요.
`pass`는 1 tick이 걸리므로 정확한 지연을 만드는 데 사용할 수 있어요.
자료 구조에 인덱싱하는 것은 인덱스 연산자에 1 tick이 걸리고, 딕셔너리나 세트의 경우 키의 크기에 따라 추가적인 틱이 걸려요.

내장 함수가 실행되는 데 걸리는 틱 수는 각 함수의 문서에 개별적으로 기록되어 있어요.